VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "rplFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Type rplActionType
    accelerateKey As Integer
    brakeKey As Integer
    leftKey As Integer
    rightKey As Integer
    shiftUpKey As Integer
    shiftDownKey As Integer
    doNothing As Integer
    otherAction As Integer
End Type

Const PCARPOS = 1
Const PCARCOL = 5
Const TRACKLENGTH = 1802
Const HEADERLENGTHOLD = 24
Const HEADERLENGTHNEW = 26

Dim rplActions As rplActionType

Private rplInFile As Integer
Public rplLengthLap As Long
Public rplLength As Long
Private headerLength As Integer

' For my version check
Public BB11 As Boolean
Public validRpl As Boolean

' For Robert Riebisch's check
Public BB11R As Boolean
Public validRplR As Boolean

Public rplTime As String
Public trackName As String
Public finished As Boolean

Public playerCarName As String
Public playerCarNum As Integer
Public playerCarColour As String
Public playerShiftMode As String
Public playerCarColourValue As Long

Private opponentNum As Byte
Public opponentPresent As Boolean
Public opponentName As String
Public opponentCarNum As Integer
Public opponentCarColour As String
Public opponentCarName As String
Public opponentShiftMode As String
Public opponentCarColourValue As Long


Private carColours(1 To 7, 1 To 12) As Byte
Private colours(0 To 10) As String '* 12
Private carNames(1 To 12) As String '* 20
Private oppName(1 To 6) As String '* 22
Private gearMode() As String '* 6
Private carAbr(1 To 12) As String
Private colourCodes(0 To 10) As Byte
Public Function readFile(fileName As String) As Boolean
        
    On Error GoTo readFile_Error
    
    rplInFile = FreeFile
    Open fileName For Binary As rplInFile
        
    'Call readVersion
    'Call determineLength
    Call readVersionRiebisch
    Call readPCar
    Call readTrack
    Call wasFinished
    Call makeTimeString
    Call analyseReplay
    Call checkOpponent
    If opponentPresent Then
        Call readOpponent
        Call readOCar
    End If
    
    Close #rplInFile
          
    readFile = validRpl
    Exit Function
    
readFile_Error:
    MsgBox ("There was a problem processing that this replay!")
    validRpl = False
    readFile = validRpl
    
End Function

Private Sub readVersion()
    If (readByteAt(23) = 20) And (readByteAt(24) = 0) Then
        BB11 = True
        headerLength = HEADERLENGTHNEW
       Else
         BB11 = False
         headerLength = HEADERLENGTHOLD
    End If
End Sub

Private Sub readVersionRiebisch()
    ' **********************************
    ' Version check by Robert Riebisch
    ' **********************************
        
    rplLength = readWordAt(23)
    If rplLength + TRACKLENGTH + HEADERLENGTHOLD = LOF(rplInFile) Then
        BB11 = False
        headerLength = HEADERLENGTHOLD
        validRpl = True
      Else
        rplLength = readWordAt(25)
        If rplLength + TRACKLENGTH + HEADERLENGTHNEW = LOF(rplInFile) Then
            BB11 = True
            headerLength = HEADERLENGTHNEW
            validRpl = True
          Else
            validRpl = False
        End If
    End If
End Sub
     
Private Function readByteAt(p As Integer) As Byte
    Get rplInFile, p, readByteAt
End Function

Private Function readWordAt(p As Integer) As Integer
    readWordAt = readByteAt(p) + readByteAt(p + 1) * 256
End Function



Private Sub readPCar()
    Dim abr As String
    Dim colnum As Integer
        
    abr = readString(PCARPOS, 4)
    
    playerCarNum = carnum(abr)
    playerCarName = carNames(playerCarNum)
    colnum = readByteAt(PCARCOL)
    
   
    playerCarColourValue = QBColor(colourCodes(carColours(colnum + 1, playerCarNum)))
    playerCarColour = tellcolour(colnum, playerCarNum)
    playerShiftMode = gearMode(readByteAt(6))
End Sub

Private Sub readOCar()
    
    Dim abr As String
    Dim colnum As Integer
        
    abr = readString(8, 4)
    
    opponentCarNum = carnum(abr)
    opponentCarName = carNames(opponentCarNum)
    colnum = readByteAt(12)
    
    opponentCarColourValue = QBColor(colourCodes(carColours(colnum + 1, opponentCarNum)))
    opponentCarColour = tellcolour(colnum, opponentCarNum)
    opponentShiftMode = gearMode(readByteAt(13))
End Sub

Private Function readString(start As Integer, length As Integer) As String

    Dim i As Integer
    Dim reader As Byte
    Dim result As String

     result = ""
     
     For i = 0 To length - 1
          
          Seek #rplInFile, i + start
          Get #rplInFile, , reader
          result = result + Chr(reader)
     Next i
     readString = result
     
End Function



Sub assignArray(ByRef destArray() As String, sourceArray)
ReDim destArray(LBound(sourceArray) To UBound(sourceArray))


    Dim count As Integer
        For count = LBound(sourceArray) To UBound(sourceArray)
        destArray(count) = sourceArray(count)
    Next count
End Sub


Private Function carnum(abr As String) As Integer
    Dim numTemp As Integer
    Dim i As Integer
    numTemp = 0
        
    For i = 1 To 12
        If abr = carAbr(i) Then numTemp = i
    Next i
       
    carnum = numTemp
    
End Function

Function tellcolour(colour As Integer, carnum As Integer)
Dim buffer As String

     If carnum > 0 Then
          tellcolour = colours(carColours(colour + 1, carnum))
      Else
          tellcolour = "Unknown (" & colour & ")"
     End If
End Function

Sub readTrack()
    trackName = readString(14, 8)

    If InStr(trackName, Chr(0)) > 0 Then trackName = Mid(trackName, 1, InStr(trackName, Chr(0)) - 1)
End Sub

Sub wasFinished()

Dim offset   As Integer, i As Integer
Dim buffer As Byte
   
   If BB11 Then offset = 1829 Else offset = 1827
   offset = offset + rplLength - 20
   
   For i = 0 To 19
        Seek rplInFile, offset + i
        Get #rplInFile, , buffer
        If buffer > 0 Then
            finished = False
            Exit Sub
        End If
   Next i
   finished = True

End Sub

Sub determineLength()
    If Not BB11 Then rplLength = readWordAt(23) Else rplLength = readWordAt(25)
End Sub


Sub makeTimeString()

    Dim mins As String, seks As String, hseks As String
    Dim m As Integer
    Dim s As Double
    Dim theTime As stuntsTime
    
     rplTime = ""
     If finished Then rplLengthLap = rplLength - 20
     
     Set theTime = New stuntsTime
     rplTime = theTime.ticksToString(rplLengthLap)
     Set theTime = Nothing
     'm = Int((rplLengthLap) / 1200)
     's = ((rplLengthLap) - m * 1200) / 20
     'mins = CStr(m)
     'If Len(mins) = 1 Then mins = "0" & mins
     
     'seks = Format(s, "#0.00")
     'If Len(seks) = 4 Then seks = "0" & seks

     'rplTime = mins + ":" & seks
     'If finished Then rplTime = rplTime ' & " (finished)"
End Sub

Sub checkOpponent()
    opponentNum = readByteAt(7)
    If opponentNum > 0 Then
        opponentPresent = True
    Else
        opponentPresent = False
    End If
End Sub

Sub readOpponent()
        
    opponentName = oppName(opponentNum)
   
End Sub

Public Sub writeTrack(rplFileName As String, trkFileName As String)
    Dim i As Integer
    Dim trkOutFile As Integer
    Dim buffer As Byte
       
    On Error GoTo trackWrite_Error
    rplInFile = FreeFile
    Open rplFileName For Binary As rplInFile
    
    trkOutFile = FreeFile
    Open trkFileName For Binary As trkOutFile
        
    Seek trkOutFile, 1
    If Not BB11 Then Seek rplInFile, 25 Else Seek rplInFile, 27
    For i = 0 To 1801
        Get rplInFile, , buffer
        Put trkOutFile, , buffer
    Next i

    Close rplInFile
    Close trkOutFile
        
    Exit Sub
trackWrite_Error:
    MsgBox ("There was an error. " & Err.description & " " & Err.Number & " " & Err.Source & " " & trkFileName & " " & rplFileName)
    
End Sub

Private Sub Class_Initialize()
Call loadCarColours
      
colourCodes(0) = 1
colourCodes(1) = 4
colourCodes(2) = 14
colourCodes(3) = 3
colourCodes(4) = 2
colourCodes(5) = 13
colourCodes(6) = 7
colourCodes(7) = 8
colourCodes(8) = 6
colourCodes(9) = 5
colourCodes(10) = 12
      
colours(0) = "blue"
colours(1) = "dark red"
colours(2) = "yellow"
colours(3) = "turquis"
colours(4) = "green"
colours(5) = "pink"
colours(6) = "light grey"
colours(7) = "grey"
colours(8) = "bottle green"
colours(9) = "dark violet"
colours(10) = "Ferrari red"
      
carNames(1) = "Porsche/March INDY"
carNames(2) = "Lamborghini Countach"
carNames(3) = "Ferrari GTO"
carNames(4) = "Jaguar XJR9"
carNames(5) = "Lancia Delta HF"
carNames(6) = "Lamborghini LM-002"
carNames(7) = "Porsche 962"
carNames(8) = "Porsche Carrera 4"
carNames(9) = "Corvette ZR1"
carNames(10) = "Acura NSX"
carNames(11) = "Audi Quattro"
carNames(12) = "Contest Car 0.9"
    
oppName(1) = "Squeling Bernie Rubber"
oppName(2) = "Herr Otto Partz"
oppName(3) = "Smoking Joe Stallin"
oppName(4) = "Cherry Chassis"
oppName(5) = "Helen Wheels"
oppName(6) = "Skid Vicious"

Call assignArray(gearMode, Array("manual", "auto"))

carAbr(1) = "PMIN"
carAbr(2) = "COUN"
carAbr(3) = "FGTO"
carAbr(4) = "JAGU"
carAbr(5) = "LANC"
carAbr(6) = "LM02"
carAbr(7) = "P962"
carAbr(8) = "PC04"
carAbr(9) = "VETT"
carAbr(10) = "ANSX"
carAbr(11) = "AUDI"
carAbr(12) = "CC09"

End Sub

Sub loadCarColours()
    
    carColours(1, 1) = 0
    carColours(2, 1) = 6
    carColours(3, 1) = 10
    carColours(4, 1) = 2
    carColours(5, 1) = 3
    carColours(6, 1) = 4
    carColours(7, 1) = 9
    
    carColours(1, 2) = 0
    carColours(2, 2) = 10
    carColours(3, 2) = 2
    carColours(4, 2) = 3
    carColours(5, 2) = 4
    carColours(6, 2) = 5
    carColours(7, 2) = 6
    
    carColours(1, 3) = 10
    carColours(2, 3) = 0
    carColours(3, 3) = 6
    carColours(4, 3) = 2
    carColours(5, 3) = 3
    carColours(6, 3) = 4
    carColours(7, 3) = 5
    
    carColours(1, 5) = 2
    carColours(2, 5) = 6
    carColours(3, 5) = 3
    carColours(4, 5) = 8
    carColours(5, 5) = 10
    carColours(6, 5) = 5
    carColours(7, 5) = 4
    
    carColours(1, 4) = 4
    carColours(2, 4) = 8
    carColours(3, 4) = 3
    carColours(4, 4) = 1
    carColours(5, 4) = 7
    carColours(6, 4) = 6
    carColours(7, 4) = 5
    
    carColours(1, 6) = 1
    carColours(2, 6) = 7
    carColours(3, 6) = 4
    carColours(4, 6) = 0
    carColours(5, 6) = 8
    carColours(6, 6) = 6
    carColours(7, 6) = 3
    
    carColours(1, 7) = 0
    carColours(2, 7) = 10
    carColours(3, 7) = 2
    carColours(4, 7) = 3
    carColours(5, 7) = 4
    carColours(6, 7) = 5
    carColours(7, 7) = 6
    
    carColours(1, 8) = 9
    carColours(2, 8) = 0
    carColours(3, 8) = 8
    carColours(4, 8) = 3
    carColours(5, 8) = 5
    carColours(6, 8) = 7
    carColours(7, 8) = 1
    
    carColours(1, 9) = 1
    carColours(2, 9) = 3
    carColours(3, 9) = 2
    carColours(4, 9) = 6
    carColours(5, 9) = 3
    carColours(6, 9) = 7
    carColours(7, 9) = 8
    
    carColours(1, 10) = 0
    carColours(2, 10) = 10
    carColours(3, 10) = 2
    carColours(4, 10) = 6
    carColours(5, 10) = 3
    carColours(6, 10) = 7
    carColours(7, 10) = 8
    
    carColours(1, 11) = 3
    carColours(2, 11) = 1
    carColours(3, 11) = 8
    carColours(4, 11) = 9
    carColours(5, 11) = 4
    carColours(6, 11) = 6
    carColours(7, 11) = 0
        
    carColours(1, 12) = 0
    carColours(2, 12) = 6
    carColours(3, 12) = 10
    carColours(4, 12) = 2
    carColours(5, 12) = 3
    carColours(6, 12) = 4
    carColours(7, 12) = 9
    
End Sub

Sub analyseReplay()
    Dim i As Integer
    ReDim byteBuffer(rplLength) As Byte
            
    Call clearActions
        
    Get rplInFile, headerLength + TRACKLENGTH + 1, byteBuffer
    
    For i = 0 To rplLength - 1
        If byteBuffer(i) = 0 Then
            rplActions.doNothing = rplActions.doNothing + 1
        ElseIf byteBuffer(i) > 63 Then
            rplActions.otherAction = rplActions.otherAction + 1
        Else
            If byteBuffer(i) And 1 Then rplActions.accelerateKey = rplActions.accelerateKey + 1
            If byteBuffer(i) And 2 Then rplActions.brakeKey = rplActions.brakeKey + 1
            If byteBuffer(i) And 4 Then rplActions.rightKey = rplActions.rightKey + 1
            If byteBuffer(i) And 8 Then rplActions.leftKey = rplActions.leftKey + 1
            If byteBuffer(i) And 16 Then rplActions.shiftUpKey = rplActions.shiftUpKey + 1
            If byteBuffer(i) And 32 Then rplActions.shiftDownKey = rplActions.shiftDownKey + 1
        End If
    Next i
End Sub

Sub clearActions()
    With rplActions
        .accelerateKey = 0
        .brakeKey = 0
        .rightKey = 0
        .leftKey = 0
        .shiftUpKey = 0
        .shiftDownKey = 0
        .doNothing = 0
        .otherAction = 0
    End With
End Sub

Public Function accessActions()
    Dim returnArray(1 To 8) As Integer
    
    With rplActions
        returnArray(1) = .accelerateKey
        returnArray(2) = .brakeKey
        returnArray(3) = .rightKey
        returnArray(4) = .leftKey
        returnArray(5) = .shiftUpKey
        returnArray(6) = .shiftDownKey
        returnArray(7) = .doNothing
        returnArray(8) = .otherAction
    End With
    
    accessActions = returnArray
    
End Function

