VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "higFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Const lineLength = 52
Const playerNameLength = 17
Const carLength = 25
Const initialsLength = 8

Dim theFileContent(0 To 363) As Byte

Private Type highStruc
    playerName As String
    playerCar As String
    timeTicks As Long
    timeStr As String
    opponentPresent As Boolean
    opponentString As String
    opponentName As String
    opponentCar As String
End Type

Dim inFile As Integer

Private fileContent(1 To 7) As highStruc

Public Function readFile(fileName As String) As Boolean
    Dim i As Integer
    
    Dim currentLine As String * 52
        
    On Error GoTo readFile_Error
        
    inFile = FreeFile
                
    Open fileName For Binary As inFile
    
        Get inFile, , theFileContent
    
    Close inFile
    Call parseFileContent
    
    readFile = True
    Exit Function
    
readFile_Error:
    readFile = False
       
End Function



Sub parseFileContent()
    Dim i As Integer
    Dim temp As Long
    Dim theTime As stuntsTime
    
    Set theTime = New stuntsTime
    
    For i = 0 To 6
        With fileContent(i + 1)
            .playerName = readCString(i * lineLength, playerNameLength)
            .playerCar = readCString(i * lineLength + playerNameLength, carLength)
            .opponentString = readCString(i * lineLength + playerNameLength + carLength, initialsLength)
            .timeTicks = theFileContent(i * lineLength + playerNameLength + carLength + initialsLength) + _
                         CLng(theFileContent(i * lineLength + playerNameLength + carLength + initialsLength + 1)) * 256
                         
            .timeStr = theTime.ticksToString(.timeTicks)
            Call parseOpponentString(.opponentString, .opponentName, .opponentCar)
        End With
    Next i
    
    
End Sub

Function readCString(pos As Integer, Optional maxLength As Integer)
    Dim currentChar As Byte
    Dim theString As String
    Dim count As Integer
        
    If IsMissing(maxLength) Then maxLength = 363
        
    Do While Not count = 363 And count < maxLength
        currentChar = theFileContent(pos + count)
        If currentChar <> 0 Then
            theString = theString & Chr(currentChar)
            count = count + 1
           Else
            Exit Do
        End If
    Loop
    readCString = theString
End Function

Public Function getPlayerName(n As Integer) As String
    getPlayerName = fileContent(n).playerName
End Function

Public Function getPlayerCar(n As Integer) As String
    getPlayerCar = fileContent(n).playerCar
End Function

Public Function getTicks(n As Integer) As Long
    getTicks = fileContent(n).timeTicks
End Function

Public Function getTimeStr(n As Integer) As String
    getTimeStr = fileContent(n).timeStr
End Function

Public Function getOpponentName(n As Integer) As String
    getOpponentName = fileContent(n).opponentName
End Function

Public Function getOpponentString(n As Integer) As String
    getOpponentString = fileContent(n).opponentString
End Function

Public Function getOpponentCar(n As Integer) As String
    getOpponentCar = fileContent(n).opponentCar
End Function

Sub parseOpponentString(theString As String, ByRef oppName As String, ByRef opponentCar As String)
    
End Sub

Public Function getDriverName(timeTicks As Long, pCar As String) As String
    Dim i As Integer
    
    For i = 1 To 7
        With fileContent(i)
            If .timeTicks = timeTicks And .playerCar = pCar Then
                getDriverName = .playerName
                Exit Function
            End If
        End With
    Next i
    getDriverName = "N/A"
    
End Function
