VERSION 4.00
Begin VB.Form Rplinfo 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "RPLINFO for Windows"
   ClientHeight    =   4170
   ClientLeft      =   2100
   ClientTop       =   1620
   ClientWidth     =   3690
   FillColor       =   &H00FFFFFF&
   ForeColor       =   &H00C0C0C0&
   Height          =   4530
   Icon            =   "RPLINFO.frx":0000
   Left            =   2040
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4170
   ScaleWidth      =   3690
   Top             =   1320
   Width           =   3810
   Begin VB.CheckBox lapFinished 
      Height          =   192
      Left            =   3269
      TabIndex        =   13
      Top             =   612
      Width           =   180
   End
   Begin VB.CommandButton Command4 
      Caption         =   "&More info"
      Enabled         =   0   'False
      Height          =   330
      Left            =   2441
      TabIndex        =   12
      Top             =   3696
      Width           =   948
   End
   Begin VB.PictureBox opponentColourDisp 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   3089
      ScaleHeight     =   225
      ScaleWidth      =   315
      TabIndex        =   9
      Top             =   3099
      Width           =   375
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Save &track"
      Enabled         =   0   'False
      Height          =   330
      Left            =   1337
      TabIndex        =   8
      Top             =   3696
      Width           =   948
   End
   Begin VB.CommandButton Command1 
      Caption         =   "&Load"
      Default         =   -1  'True
      Height          =   330
      Left            =   233
      TabIndex        =   7
      Top             =   3696
      Width           =   948
   End
   Begin VB.PictureBox playerColourDisp 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   3089
      ScaleHeight     =   225
      ScaleWidth      =   315
      TabIndex        =   6
      Top             =   1815
      Width           =   375
   End
   Begin MSComDlg.CommonDialog Dialog 
      Left            =   1260
      Top             =   1215
      _version        =   65536
      _extentx        =   847
      _extenty        =   847
      _stockprops     =   0
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Track"
      Height          =   192
      Left            =   245
      TabIndex        =   21
      Top             =   216
      Width           =   420
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Time"
      Height          =   192
      Left            =   245
      TabIndex        =   20
      Top             =   600
      Width           =   372
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Your car"
      Height          =   192
      Left            =   245
      TabIndex        =   19
      Top             =   1140
      Width           =   600
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Shift mode"
      Height          =   192
      Left            =   245
      TabIndex        =   18
      Top             =   1488
      Width           =   756
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Colour"
      Height          =   192
      Left            =   240
      TabIndex        =   17
      Top             =   1860
      Width           =   468
   End
   Begin VB.Label Label12 
      AutoSize        =   -1  'True
      Caption         =   "Colour"
      Height          =   192
      Left            =   240
      TabIndex        =   16
      Top             =   3120
      Width           =   468
   End
   Begin VB.Label Label14 
      AutoSize        =   -1  'True
      Caption         =   "Opponent's Car"
      Height          =   192
      Left            =   245
      TabIndex        =   15
      Top             =   2760
      Width           =   1116
   End
   Begin VB.Label Label16 
      AutoSize        =   -1  'True
      Caption         =   "Opponent"
      Height          =   192
      Left            =   245
      TabIndex        =   14
      Top             =   2424
      Width           =   708
   End
   Begin VB.Label opponentCar 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   288
      Left            =   1733
      TabIndex        =   11
      Top             =   2748
      Width           =   1728
   End
   Begin VB.Label opponentName 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   288
      Left            =   1733
      TabIndex        =   10
      Top             =   2388
      Width           =   1728
   End
   Begin VB.Line Line6 
      BorderColor     =   &H00404040&
      X1              =   192
      X2              =   3532
      Y1              =   3468
      Y2              =   3468
   End
   Begin VB.Line Line5 
      BorderColor     =   &H00FFFFFF&
      X1              =   204
      X2              =   3544
      Y1              =   3480
      Y2              =   3480
   End
   Begin VB.Line Line4 
      BorderColor     =   &H00404040&
      X1              =   172
      X2              =   3512
      Y1              =   2208
      Y2              =   2208
   End
   Begin VB.Line Line3 
      BorderColor     =   &H00FFFFFF&
      X1              =   172
      X2              =   3512
      Y1              =   2220
      Y2              =   2220
   End
   Begin VB.Line Line2 
      BorderColor     =   &H00404040&
      X1              =   172
      X2              =   3512
      Y1              =   948
      Y2              =   948
   End
   Begin VB.Line Line1 
      BorderColor     =   &H00FFFFFF&
      X1              =   172
      X2              =   3512
      Y1              =   960
      Y2              =   960
   End
   Begin VB.Label opponentColour 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   288
      Left            =   1733
      TabIndex        =   5
      Top             =   3096
      Width           =   1308
   End
   Begin VB.Label playerColour 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   288
      Left            =   1733
      TabIndex        =   4
      Top             =   1812
      Width           =   1308
   End
   Begin VB.Label playerShift 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   288
      Left            =   1733
      TabIndex        =   3
      Top             =   1452
      Width           =   1728
   End
   Begin VB.Label playerCar 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   288
      Left            =   1733
      TabIndex        =   2
      Top             =   1092
      Width           =   1728
   End
   Begin VB.Label trackTime 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   288
      Left            =   1733
      TabIndex        =   1
      Top             =   552
      Width           =   1404
   End
   Begin VB.Label trackName 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   288
      Left            =   1733
      TabIndex        =   0
      Top             =   192
      Width           =   1728
   End
End
Attribute VB_Name = "Rplinfo"
Attribute VB_Creatable = False
Attribute VB_Exposed = False



Option Explicit

Const version = "1.1"

Const RPLEXT = "RPL"
Const TRKEXT = "TRK"
Const FORMTITLE = "RPLINFO"
Dim myFile As rplFile
Dim fname As String
Dim fState As Integer

Private Sub Command1_Click()
    Dim file_name As String
    Dim file_title As String
        
    If Not get_fname_for_load(RPLEXT, "4D/Stunts replay file", "Load replay", file_name, file_title) Then Exit Sub

    fname = file_name
    Call openFile(fname)
    
End Sub

Private Sub Command2_Click()
    Dim file_name As String
    Dim file_title As String
    
    file_name = (Trim(myFile.trackName) + ".trk")
    
    If Not get_fname_for_save(TRKEXT, "4D/Stunts track file", "Save track", file_name, file_title) Then Exit Sub
    
    Call myFile.writeTrack(fname, file_name)
End Sub



Private Sub Command4_Click()
    Dim returnArray
    'moreInfo.versionRiebisch.ToolTipText = "Version according to a detection method by Robert Riebisch"
         
    If myFile.BB11 Then
        moreInfo.versionRiebisch = "New replay file format detected." + Chr(13) + Chr(10) + _
            "Compatible with Stunts (FEB-12-91) and 4D Sports Driving (FEB-25-91)."
        'moreInfo.versionRiebisch.ToolTipText = "Replays are *fully* compatible between these two versions!"
      Else
        moreInfo.versionRiebisch.Caption = "Old replay file format detected." + Chr(10) + Chr(13) + _
          "Compatible with Stunts (OCT-05-90) and 4D Sports Driving (DEC-13-90)"
        'moreInfo.versionRiebisch.ToolTipText = "Replays are *not* compatible between these two versions!"
    End If
    returnArray = myFile.accessActions
    
    moreInfo.aAcc = returnArray(1)
    moreInfo.aBrake = returnArray(2)
    moreInfo.aRight = returnArray(3)
    moreInfo.aLeft = returnArray(4)
    moreInfo.aUp = returnArray(5)
    moreInfo.aDown = returnArray(6)
    moreInfo.aNothing = returnArray(7)
    moreInfo.aUnkown = returnArray(8)
    
    If myFile.opponentPresent Then
        moreInfo.opponentShiftMode = myFile.opponentShiftMode
       Else
        moreInfo.Label6.Enabled = False
    End If
    
    moreInfo.Show 1
End Sub

Private Sub Form_Load()

Set myFile = New rplFile

Dim commandLine As Variant
Dim nargs As Integer
Dim file_name As String

commandLine = GetCommandLine(nargs, 1)

Me.Caption = Me.Caption + " " + version

If nargs > 0 Then
    file_name = commandLine(1)
    If FileExists(file_name) Then
        fname = file_name
        Call openFile(file_name)
    End If
End If
End Sub
Sub openFile(file_name As String)
    Call clearData
    If myFile.readFile(file_name) Then Call setData(myFile)
End Sub



Sub clearData()
    playerColour.Caption = ""
    trackName.Caption = ""
    trackTime.Caption = ""
    playerShift.Caption = ""
    playerCar.Caption = ""
    playerColourDisp.BackColor = &HFFFFFF
      
    opponentName.Caption = ""
    opponentCar.Caption = ""
    opponentColour.Caption = ""
    opponentColourDisp.BackColor = &HFFFFFF
    
    lapFinished.Value = 0
    Me.Caption = FORMTITLE
    Command4.Enabled = False
    Command2.Enabled = False
    
    Label16.Enabled = True
    Label14.Enabled = True
    Label12.Enabled = True
    
End Sub


Sub setData(ByRef sourceFile As rplFile)
    playerColour.Caption = sourceFile.playerCarColour
    trackName.Caption = sourceFile.trackName
    trackTime.Caption = sourceFile.rplTime
    playerShift.Caption = sourceFile.playerShiftMode
    playerCar.Caption = sourceFile.playerCarName
    playerColourDisp.BackColor = sourceFile.playerCarColourValue
    lapFinished.Value = Abs(CInt(sourceFile.finished))
                                    
       If sourceFile.opponentPresent Then
          opponentName.Caption = sourceFile.opponentName
          opponentCar.Caption = sourceFile.opponentCarName
          opponentColour.Caption = sourceFile.opponentCarColour
          opponentColourDisp.BackColor = sourceFile.opponentCarColourValue
        Else
          opponentName.Caption = ""
          opponentCar.Caption = ""
          opponentColour.Caption = ""
          opponentColourDisp.BackColor = &HFFFFFF
          Label16.Enabled = False
          Label14.Enabled = False
          Label12.Enabled = False
       End If
       Me.Caption = FORMTITLE & " - " & fileNameOnly(fname)
       Command4.Enabled = True
       Command2.Enabled = True
End Sub



Function reverseString(rstr As String) As String

Dim i As Integer
Dim buffer As String
buffer = ""
For i = Len(rstr) To 1 Step -1
    buffer = buffer & Mid(rstr, i, 1)
Next i

reverseString = buffer

End Function

Function fileNameOnly(pathString As String) As String
    Dim buffer As String
    
    buffer = reverseString(pathString)
    fileNameOnly = reverseString(Mid(buffer, 1, InStr(buffer, "\") - 1))
    
    
End Function
Function get_fname_for_load(ext As String, description As String, title As String, file_path As String, file_name As String) As Boolean
'gibt falsch zurck, falls Cancel gedrckt wurde

On Error GoTo file_open_error
    
Dialog.fileName = fname
Dialog.DialogTitle = title
Dialog.Filter = description + " (*." + ext + ")|*." + ext + "|All Files (*.*)|*.*"
Dialog.DefaultExt = ext
Dialog.CancelError = True
Dialog.Flags = &H2 + &H4
Dialog.ShowOpen
    
file_path = Dialog.fileName
file_name = Dialog.FileTitle

If Not FileExists(file_path) Then
  MsgBox ("File does not exist!")
  Err.Raise cdlCancel
End If

get_fname_for_load = True
Exit Function

file_open_error:
 If Err = cdlCancel Then
   get_fname_for_load = False
  Exit Function
 End If
Resume

End Function

Function get_fname_for_save(ext As String, description As String, title As String, file_path As String, file_name As String) As Boolean
'gibt falsch zurck, falls Cancel gedrckt wurde

  On Error GoTo file_open_error
    
    Dialog.fileName = file_path
    'Dialog.FileTitle = file_name
    Dialog.DialogTitle = title
    Dialog.Filter = description + " (*." + ext + ")|*." + ext + "|All Files (*.*)|*.*"
    Dialog.DefaultExt = ext
    Dialog.CancelError = True
    Dialog.Flags = &H2 + &H4

    Dialog.ShowSave
    
    file_path = Dialog.fileName
    file_name = Dialog.FileTitle
    get_fname_for_save = True

    Exit Function
  On Error GoTo 0

file_open_error:
 If Err = cdlCancel Then
  get_fname_for_save = False
  Exit Function
 End If
Resume Next
    
End Function

Public Function FileExists(p As String) As Boolean
    On Error GoTo fileError:
        If Dir(p) <> "" Then FileExists = True Else FileExists = False
    On Error GoTo 0
    Exit Function
fileError:
    FileExists = False
    
End Function

Function GetCommandLine(n As Integer, Optional MaxArgs)

    'Declare variables.
    Dim C, CmdLine, CmdLnLen, InArg, i, NumArgs
    'See if MaxArgs was provided.
    If IsMissing(MaxArgs) Then MaxArgs = 10
    'Make array of the correct size.
    ReDim ArgArray(MaxArgs)
    NumArgs = 0: InArg = False
    'Get command line arguments.
    CmdLine = Command()
    CmdLnLen = Len(CmdLine)
    'Go thru command line one character
    'at a time.
    For i = 1 To CmdLnLen
        C = Mid(CmdLine, i, 1)

    'Test for space or tab.
        If (C <> " " And C <> vbTab) Then
            'Neither space nor tab.
            'Test if already in argument.
            If Not InArg Then
            'New argument begins.
            'Test for too many arguments.
                If NumArgs = MaxArgs Then Exit For
                NumArgs = NumArgs + 1
                InArg = True
            End If
            'Concatenate character to current argument.
            ArgArray(NumArgs) = ArgArray(NumArgs) & C
        Else
            'Found a space or tab.

    'Set InArg flag to False.
            InArg = False
        End If
    Next i
    'Resize array just enough to hold arguments.
    ReDim Preserve ArgArray(NumArgs)
    'Return Array in Function name.
    GetCommandLine = ArgArray()
    n = NumArgs
End Function

Private Sub lapFinished_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    ' Stupid workaround! How can I create a "click-protected" checkbox?
    fState = lapFinished.Value
End Sub

Private Sub lapFinished_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    lapFinished.Value = fState
End Sub
