/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.RandomAccessFile;

public class rplFile
extends rplData {
    String fileName;
    RandomAccessFile theFile;
    boolean BB11;
    boolean finished;
    boolean opponentPresent;
    String rplTimeStr;
    byte[] fileHeader;
    int fileLength;
    String trackName;
    int rplLength;
    int headerLength;
    String playerCarName;
    String playerCarColour;
    String playerShiftMode;
    int playerCarNum;
    int playerCarColourNum;
    String opponentName;
    String opponentCarName;
    String opponentCarColour;
    String opponentShiftMode;
    int opponentCarNum;
    int opponentCarColourNum;
    int opponentNum;

    public void processFile(String string) throws IOException {
        this.theFile = new RandomAccessFile(string, "r");
        this.fileName = string;
        this.readHeader();
        this.readPlayerCar();
        this.readTrack();
        this.determineLength();
        this.wasFinished();
        this.makeTimeString();
        this.checkOpponent();
        if (this.opponentPresent) {
            this.opponentName = rplData.oppNames[this.opponentNum - 1];
            this.readOpponentCar();
        }
        this.theFile.close();
    }

    public String getOppName() {
        return this.opponentName;
    }

    private void readVersion() throws IOException {
        this.theFile.seek(22L);
        if (this.theFile.read() == 20) {
            this.theFile.seek(23L);
            if (this.theFile.read() == 0) {
                this.BB11 = true;
                return;
            }
        }
        this.BB11 = false;
    }

    /*
     * Unable to fully structure code
     */
    private void readHeader() throws IOException {
        block2: {
            this.fileLength = (int)this.theFile.length();
            if (this.fileLength < 1826) break block2;
            this.theFile.seek(22L);
            if (this.theFile.read() != 20) ** GOTO lbl-1000
            this.theFile.seek(23L);
            if (this.theFile.read() == 0) {
                this.BB11 = true;
            } else lbl-1000:
            // 2 sources

            {
                this.BB11 = false;
            }
            this.headerLength = this.BB11 != false ? 26 : 24;
            this.fileHeader = new byte[this.headerLength];
            this.theFile.seek(0L);
            this.theFile.read(this.fileHeader, 0, this.headerLength);
        }
    }

    private int readByteAt(int n) throws IOException {
        this.theFile.seek(n);
        return this.theFile.read();
    }

    private void readPlayerCar() throws IOException {
        String string = new String(this.fileHeader, 0, 4);
        this.playerCarNum = this.carNum(string);
        this.playerCarName = rplData.carNames[this.playerCarNum];
        byte by = this.fileHeader[4];
        this.playerCarColour = this.tellColour(by, this.playerCarNum);
        this.playerShiftMode = rplData.gearMode[this.fileHeader[5]];
    }

    private int carNum(String string) {
        int n = 0;
        while (n < 11) {
            if (string.equals(rplData.carAbr[n])) break;
            ++n;
        }
        return n;
    }

    private String tellColour(int n, int n2) {
        if (n2 > -1) {
            return rplData.colours[rplData.carColours[n2][n]];
        }
        return "Unknown (" + n + ")";
    }

    private void readTrack() {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byte by = this.fileHeader[13 + n];
            if (by == 0) break;
            byArray[n] = by;
            ++n;
        }
        this.trackName = new String(byArray, 0, n);
    }

    private void determineLength() {
        if (!this.BB11) {
            int n = this.fileHeader[22];
            int n2 = n < 0 ? n + 256 : n;
            n = this.fileHeader[23];
            this.rplLength = n2 + (n < 0 ? n + 256 : n) * 256;
            return;
        }
        int n = this.fileHeader[24];
        int n3 = n < 0 ? n + 256 : n;
        n = this.fileHeader[25];
        this.rplLength = n3 + (n < 0 ? n + 256 : n) * 256;
    }

    private int convertByteProperly(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    private void wasFinished() throws IOException {
        if (this.fileLength != this.headerLength + 1802 + this.rplLength) {
            throw new IOException("Wrong file Length");
        }
        int n = 1802 + this.headerLength;
        n = n + this.rplLength - 20;
        int n2 = 0;
        while (n2 < 20) {
            this.theFile.seek(n + n2);
            int n3 = this.theFile.read();
            if (n3 > 0) {
                this.finished = false;
                return;
            }
            ++n2;
        }
        this.finished = true;
    }

    private void makeTimeString() {
        String string;
        if (this.finished) {
            this.rplLength -= 20;
        }
        int n = this.rplLength / 1200;
        double d = (double)(this.rplLength - n * 1200) / 20.0;
        String string2 = String.valueOf(n);
        if (string2.length() == 1) {
            string2 = new String("0" + string2);
        }
        if ((string = String.valueOf(d)).length() < 4) {
            string = new String("0" + string);
        }
        if (string.length() < 5) {
            string = new String(String.valueOf(string) + "0");
        }
        this.rplTimeStr = String.valueOf(string2) + ":" + string;
    }

    private void checkOpponent() {
        this.opponentNum = this.fileHeader[6];
        if (this.opponentNum > 0) {
            this.opponentPresent = true;
            return;
        }
        this.opponentPresent = false;
    }

    private void readOpponent() {
        this.opponentName = rplData.oppNames[this.opponentNum - 1];
    }

    private void readOpponentCar() throws IOException {
        String string = new String(this.fileHeader, 0, 4);
        this.opponentCarNum = this.carNum(string);
        this.opponentCarName = rplData.carNames[this.opponentCarNum];
        byte by = this.fileHeader[11];
        this.opponentCarColour = this.tellColour(by, this.opponentCarNum);
        this.opponentShiftMode = rplData.gearMode[this.fileHeader[12]];
    }

    public String toString() {
        String string = this.opponentPresent ? String.valueOf(this.opponentName) + "\n" + this.opponentCarName + "\n" + this.opponentCarColour + "\n" + this.opponentShiftMode : "No opponent present!";
        return String.valueOf(this.trackName) + "\n" + "Time: " + this.rplTimeStr + "\n" + "\n" + this.playerCarName + "\n" + this.playerCarColour + "\n" + this.playerShiftMode + "\n" + "\n" + string;
    }

    public void toTextScreen() {
        System.out.println(this.trackName);
        System.out.println("Time: " + this.rplTimeStr);
        System.out.println();
        System.out.println(this.playerCarName);
        System.out.println(this.playerCarColour);
        System.out.println(this.playerShiftMode);
        System.out.println();
        if (this.opponentPresent) {
            System.out.println(this.opponentName);
            System.out.println(this.opponentCarName);
            System.out.println(this.opponentCarColour);
            System.out.println(this.opponentShiftMode);
            return;
        }
        System.out.println("No opponent present!");
    }

    public void saveTrack(String string) {
        RandomAccessFile randomAccessFile;
        block12: {
            randomAccessFile = null;
            RandomAccessFile randomAccessFile2 = null;
            byte[] byArray = new byte[1802];
            try {
                try {
                    randomAccessFile2 = new RandomAccessFile(this.fileName, "r");
                    randomAccessFile = new RandomAccessFile(string, "rw");
                    randomAccessFile2.seek(this.headerLength);
                    randomAccessFile2.read(byArray);
                    randomAccessFile.write(byArray);
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
                Object var6_6 = null;
                if (randomAccessFile2 == null) break block12;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var6_7 = null;
                    if (randomAccessFile2 != null) {
                        try {
                            randomAccessFile2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (randomAccessFile == null) break block14;
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                randomAccessFile2.close();
            }
            catch (IOException iOException) {}
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void main(String[] stringArray) {
        rplFile rplFile2 = new rplFile();
        try {
            rplFile2.processFile(stringArray[0]);
        }
        catch (IOException iOException) {
            System.out.print("Well, it failed.");
        }
        System.out.println(rplFile2);
    }
}

